# Stop and disable the service if still running.
systemctl is-active --quiet broadcom-nfc.service
if [ $? -eq 0 ] 
then 
    systemctl stop broadcom-nfc
    systemctl disable broadcom-nfc
fi

# Save the config file if it still exists.
if test -f "/usr/lib/broadcom-nfc/bcmnfcd.conf"; then
    mv /usr/lib/broadcom-nfc/bcmnfcd.conf /usr/lib/broadcom-nfc/bcmnfcd.conf.save
fi

cp -r usr/* /usr/
cp -r etc/* /etc/
cp -r lib/* /lib/

# Update the config file to have the system type and system model
hostnamectl | awk 'BEGIN{FS=": "} {if ($1 ~ /Chassis/) printf("SYSTEM_TYPE=%s\n",$2); if ($1 ~ /Hardware Model/) printf("SYSTEM_MODEL=%s\n",$2)}' >> /usr/lib/broadcom-nfc/bcmnfcd.conf

systemctl start broadcom-nfc
systemctl enable broadcom-nfc

echo "Installation completed successfully"
