-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/cfg/cfg.adb,v $
--  Description     : Storing & Retrieving configuration data                --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 22-Mar-2004                                            --
--  Last Modified By: $Author: merdmann $                               --
--  Last Modified On: $Date: 2004/04/25 18:57:10 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2004 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  R.1 - The handling of the tree nodes is currently not task save          --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                       use Ada.Text_IO;
with Ada.Strings.Unbounded;             use Ada.Strings.Unbounded;
with Ada.Strings;                       use Ada.Strings;
with Ada.Strings.Fixed;                 use Ada.Strings.Fixed;

with Tables;

package body CFG is

   Version : constant String :=
      "$Id: cfg.adb,v 1.5 2004/04/25 18:57:10 merdmann Exp $";

   package PT is new Tables( Unbounded_String );
   use PT;

   Names : Tree_Node_Access := Create_Tree;

   ---------
   -- Get --
   ---------
   function Get(
      S      : in String ) return String is
      Result : Unbounded_String ;
   begin
      Fetch( Names, S, Result );
      return To_String( Result );
   exception
      when Entry_Not_Found =>
         return "<not defined>";
   end Get ;

   ---------
   -- Add --
   ---------
   procedure Add(
      S     : in String ) is
      Start : Natural := Index( S, "=");

     function Convert(
         S : in String ) return String is
         T : String( 1..2*S'Length );
         K : Natural := T'First;
      begin
         for I in S'Range loop
            T(K) := S(I);
            K := K + 1;
            if S(I) = '\' then
               T(K) := S(I);
               K := K + 1;
            end if;
         end loop;
         return T(1..K-1);
      end Convert;

   begin
      PT.Insert( Names,
         Trim( S(1..Start-1), Both ),
         To_Unbounded_String(Convert(Trim( S(Start+1.. S'Last), Both )))
         );
   end Add;


   --------------
   -- Load_CFG --
   --------------
   procedure Load_CFG(
      Name   : in String ) is
      F      : File_Type;
      Line   : String( 1..4000 );
      Length : Natural := 0;
   begin
      Open( File => F, Name => Name , Mode => In_File );

      while not End_of_File(F) loop
         Get_Line( F, Line, Length );

         if Length > 0 then
            declare
               Value : String := Trim( Line(1..Length ), Both );
            begin
               if Value(1) /= '#' and Value(1) /= '.' then
                  Add( Value );
               end if;
            exception
               when PT.ALREADY_STORED =>
                  if not Opt_Silent then
                     Put_Line("Definition '" & value & "' ignored" );
                  end if;
            end ;
         end if;
      end loop;

      Close(F);
   end Load_CFG;

   procedure Save_CFG is
      F      : File_Type;
   begin
      null;
   end Save_CFG;

end CFG;



