/*
 * Copyright (C) 2008-2009 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_rvdecoder.h
 *
 * Description:    Head file for RealMedia video decoder plugin for Gstreamer.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 * Aug 22 2008 Sario HU <b01138@freescale.com>
 * - Initial version
 *
 */


#ifndef __MFW_GST_RV_DECODER_H__
#define __MFW_GST_RV_DECODER_H__

/*===============================================================================
                            INCLUDE FILES
=============================================================================*/

/* None. */

/*=============================================================================
                                           CONSTANTS
=============================================================================*/

/* None. */

/*=============================================================================
                                             ENUMS
=============================================================================*/

/* None. */

/*=============================================================================
                                            MACROS
=============================================================================*/
G_BEGIN_DECLS
#define MFW_GST_TYPE_RV_DECODER \
  (mfw_gst_rv_decoder_get_type())
#define MFW_GST_RV_DECODER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),MFW_GST_TYPE_RV_DECODER,\
   MFW_GST_RV_DECODER_INFO_T))
#define MFW_GST_RV_DECODER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),MFW_GST_TYPE_RV_DECODER,\
   MFW_GST_DIVX_DECODER_CLASS_T))
#define MFW_GST_IS_RV_DECODER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),MFW_GST_TYPE_RV_DECODER))
#define MFW_GST_IS_RV_DECODER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),MFW_GST_TYPE_RV_DECODER))

#define MAX_TIMESTAMP_SHIFT 3
#define MAX_TIMESTAMP (1<<MAX_TIMESTAMP_SHIFT)
#define TIMESTAMP_INDEX_MASK (MAX_TIMESTAMP-1)

/*=============================================================================
                                 STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/

typedef int         RV_Boolean;

typedef struct {
    guint32                 start_image;
    guint32                 stop_image;
    guint32                 percent_packet_loss; /* 0 .. 100 */
    RV_Boolean          smoothing_postfilter;
    RV_Boolean          latency_mode;
    RV_Boolean          quiet;
    RV_Boolean          verbose;
    RV_Boolean          display;
    RV_Boolean          stepDisplay;

#ifdef KEY_FRAME_SEEK_SUPPORT
	RV_Boolean			keyFrameFound;
	guint32					seek_key_frame_mode;
	guint32					frames_to_decode_bef_seek;
	guint32					enableSkip;

#endif

#ifdef RMFF_DECODE
	guint32                 version;
#endif

	RV_Boolean cpu_scalable;
	guint32 cpu_scalability_val;

	RV_Boolean drop_bframe;
}rv_option;

typedef struct rv_decode_struct
{

    guint32                     m_SPOExtra;
    guint32                     m_StreamVersion;
    guint32                     m_MajorBitstreamVersion;
    guint32                     m_MinorBitstreamVersion;
    guint32                     m_NumResampledImageSizes;
    guint32                     m_EncodeSize;
    guint32                     m_LargestPels;
    guint32                     m_LargestLines;
    guint32                     m_pDimensions[2*(8+1)];
    guint32                     m_OutSize;
    guint32                     m_ECCMask;
    guint32                     m_bInputFrameIsReference;
    guint32                     m_InputFrameQuant;
} rv_decoder_front;



typedef struct MFW_GST_RV_DECODER_INFO_S {
    GstElement element;
    GstPad *sinkpad;
    GstPad *srcpad;
    gboolean init_done;
    
    RV_Decoder_config * rvConfig;
    struct RVDecoder * rvDecoder;
    RV_FID fid;
    struct RV_Image rv_img_src;
    struct RV_Image rv_img_des;
    gboolean is_rv8;

    gint rmversion;
    gint width;
    gint height;
    gint frame_width_padded;    /* padded width */
    gint frame_height_padded;
    gboolean eos;		/*flag to check the end of 
    stream */
    gboolean caps_set;		/*flag to check whether
    capabilities or set or not */
    glong Time;
    glong chain_Time;
    glong no_of_frames;
    glong no_of_frames_dropped;
    gfloat avg_fps_decoding;
    gfloat frame_rate;		/* frame rate */
    gint32 decoded_frames;	/* number of frames decoded */
    GstBuffer *outbuff;
    gint cur_buf;
    gboolean send_newseg;
    GstClockTime next_ts;    /* next output timestamp */
    guint32 moftag;
    guint32 submoftag;
    rv_decoder_front * rvfront;
    rv_option rvopt;
    gboolean flushLastFrameOutput;
    GstClockTime    timestampBuf[MAX_TIMESTAMP];
    guint timestamprx;
    guint timestamptx;
#ifdef MEMORY_DEBUG
    Mem_Mgr memmgr;
#endif
    
} MFW_GST_RV_DECODER_INFO_T;

typedef struct MFW_GST_RV_DECODER_CLASS_S {
    GstElementClass parent_class;

} MFW_GST_RV_DECODER_CLASS_T;

/*=============================================================================
                                 GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                                     FUNCTION PROTOTYPES
=============================================================================*/

GType mfw_gst_rv_decoder_get_type(void);

G_END_DECLS
/*===========================================================================*/
#endif				/* __MFW_GST_RV_DECODER_H__ */
