#!/bin/sh

if [ `grep -qs '^Purpose: PRIMARY' /CurrentlyBuilding; echo $?` -ne 0 ] ||
   [ `grep -Pqs '^Component: main|restricted' /CurrentlyBuilding; echo $?` -ne 0 ]; then
    echo "No primary archive build or not targetting main|restricted -> not generating l10n content."
    exit 0
fi

if [ -z ${KUBUNTU_DESKTOP_POT} ]; then
    KUBUNTU_DESKTOP_POT=$1;
fi;
echo KUBUNTU_DESKTOP_POT: ${KUBUNTU_DESKTOP_POT};

# Add Ubuntu gettext domain to desktop files.
if [ -f /usr/lib/kubuntu-desktop-i18n/findfiles ]; then
    sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST;
    sed /\.pc/d LIST -i;
    cat LIST;
    # add translation domain to files \
    for file in `cat LIST`; do
      echo X-Ubuntu-Gettext-Domain=desktop_${KUBUNTU_DESKTOP_POT} >> ${file};
    done;
    rm -f LIST; \
fi

if [ "`dpkg-architecture -qDEB_BUILD_ARCH`" != "i386" ]; then
    echo "No i386 build -> not generating l10n content."
    exit 0
fi

# Generating translation templates for general messages as well as those
# extractable from XML files.
mkdir -p po
extract-messages.sh
extract-xml.sh
for file in po/*pot; do \
    sed "s/charset=CHARSET/charset=UTF-8/" -i $file; \
done

# Generate translation templates for desktop files.
if [ -f /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl ]; then
    if [ -f /usr/lib/kubuntu-desktop-i18n/findfiles ]; then
        sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST;
        sed /\.pc/d LIST -i;
    fi
    perl /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl --file-list=LIST --base-dir=. > desktop.${KUBUNTU_DESKTOP_POT}.tmp;
    msguniq --to-code=UTF-8 --no-wrap -o desktop.${KUBUNTU_DESKTOP_POT} desktop.${KUBUNTU_DESKTOP_POT}.tmp 2>/dev/null;
    python /usr/lib/kubuntu-desktop-i18n/msgsplit desktop.${KUBUNTU_DESKTOP_POT};
    mv desktop.${KUBUNTU_DESKTOP_POT} po/desktop_${KUBUNTU_DESKTOP_POT}.pot;
    rm -f desktop.${KUBUNTU_DESKTOP_POT} desktop.${KUBUNTU_DESKTOP_POT}.tmp;
    rm -f LIST; 
fi
