/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CAddApplicationWindow.h

Description:

    This file defines class CAddApplicationWindow.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Jin Xin   2008/9/10

  =====================================================================

****************************************************************************/

#ifndef CADDAPPLICATIONWINDOW_H_
#define CADDAPPLICATIONWINDOW_H_

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "CSESWindowBase.h"
#include "libsesdata.h"
#include "CSearchProgramBase.h"

namespace LibSESGUI
{

class CAddApplicationWindow : public CSESWindowBase
{
public:
	//CAddApplicationWindow();
	explicit CAddApplicationWindow(bool isForTeacher);
	virtual ~CAddApplicationWindow();

public:
	// Standard window handler
	virtual int Init();

public:
	// I/Fs
	int GetSelectApplicationList(std::list<LibSESData::CApplicationInfo>& appList);

	int AddNewApplication(const LibSESData::CApplicationInfo& appInfo);

public:
	//GTK handler
	static void GtkSearchBtnClicked(GtkWidget *widget, gpointer data);
	static void GtkOKBtnClicked(GtkWidget *widget, gpointer data);
	static void GtkCancelBtnClicked(GtkWidget *widget, gpointer data);
	//static void GtkCloseBtnClicked(GtkWidget *widget, gpointer data);
	static gboolean GtkOnCloseBtnClicked(GtkWidget *widget, GdkEvent *event, gpointer data);

	static void GtkTreeSelectionForeachFunc(GtkTreeModel *model,
	                                        GtkTreePath *path,
	                                        GtkTreeIter *iter,
	                                        gpointer data);

	static void GtkSearchProgramDlgClosed(GtkWidget *widget, gpointer data);

public:
	int Close();


private:
	// Internal function
	void OnSearchBtnClicked();

	int LoadXMLData();

private:
	//GTK member
	//GtkWidget *window;
	GtkWidget*      m_gVbox;
	GtkWidget*		m_gEventBox;
	GtkWidget*      m_gCList;
	GtkWidget*      m_gHbox;
	GtkWidget*      m_gSearchBtn;
	GtkWidget*      m_gOKBtn;
	GtkWidget*      m_gCancelBtn;
	GtkListStore* 	m_gAppListStore;
	GtkWidget* 		m_gAppTreeView;
	GtkTreeIter 	m_gTreeIter;

	GtkWidget*         m_gScrolledWindow;
	GtkCellRenderer*   m_gRenderer;
	GtkTreeViewColumn* m_gColumn;
	GdkPixbuf*         m_gPixbuf;

private:
	//Internal member
	bool	m_bIsOK;
	bool 	m_bForTeacher;
	int		m_iSearchResultSum;

	CSearchProgramBase* 	m_pSearchProgramDlg;

	LibSESData::CSearchResultData	 		m_SearchResult;
	std::list<LibSESData::CApplicationInfo> m_SelectAppList;
};

}

#endif /* CADDAPPLICATIONWINDOW_H_ */
