/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CSESWindowBase.h

Description:

    This file defines class CSESWindowBase.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Jin Xin  2008/9/10

  =====================================================================

****************************************************************************/

#ifndef CSESWINDOWBASE_H_
#define CSESWINDOWBASE_H_

#include <gtk/gtk.h>
#include "CCommonDef.h"
#include <glib/gi18n.h>

namespace LibSESGUI
{

class CSESWindowBase
{
public:
	CSESWindowBase();
	virtual ~CSESWindowBase();

public:
	virtual int Init() = 0;
	virtual int Show();
	virtual int ShowModal(GtkWidget* pParentWnd, GCallback cb = NULL, gpointer data = NULL);
	virtual int Hidden();
	virtual int Close();

private:
	void	DestoryWindow();

protected:
	GtkWidget* 	m_pMainWindow;

	bool		m_bIsInitialized;
	bool		m_bIsShown;
	bool		m_bIsModal;
	bool 		m_bIsDisposing;	// prevent from reentrance destroy.

};

}

#endif /* CSESWINDOWBASE_H_ */
