/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla embedding.
 *
 * The Initial Developer of the Original Code is
 * Benjamin Smedberg <benjamin@smedbergs.us>.
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Mozilla Foundation <http://www.mozilla.org/>. All Rights Reserved.
 *
 * Contributor(s):
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// This file is an implementation file, meant to be #included in a
// single C++ file of an embedding application. It is called after
// XPCOMGlueStartup to glue the moz-headless functions.

#include "moz-headless.h"
#include "moz-headless-internal.h"
#include "nsXPCOMGlue.h"

#ifndef XPCOM_GLUE
#error This file only makes sense when XPCOM_GLUE is defined.
#endif

#define MOZHEADLESS_FUNCTIONS \
  HEADLESSF(moz_headless_get_type) \
  HEADLESSF(moz_headless_new) \
  HEADLESSF(moz_headless_push_startup) \
  HEADLESSF(moz_headless_pop_startup) \
  HEADLESSF(moz_headless_set_path) \
  HEADLESSF(moz_headless_set_comp_path) \
  HEADLESSF(moz_headless_set_profile_path) \
  HEADLESSF(moz_headless_load_url) \
  HEADLESSF(moz_headless_stop_load) \
  HEADLESSF(moz_headless_can_go_back) \
  HEADLESSF(moz_headless_can_go_forward) \
  HEADLESSF(moz_headless_go_back) \
  HEADLESSF(moz_headless_go_forward) \
  HEADLESSF(moz_headless_render_data) \
  HEADLESSF(moz_headless_open_stream) \
  HEADLESSF(moz_headless_append_data) \
  HEADLESSF(moz_headless_close_stream) \
  HEADLESSF(moz_headless_get_link_message) \
  HEADLESSF(moz_headless_get_js_status) \
  HEADLESSF(moz_headless_get_title) \
  HEADLESSF(moz_headless_get_location) \
  HEADLESSF(moz_headless_reload) \
  HEADLESSF(moz_headless_set_chrome_mask) \
  HEADLESSF(moz_headless_get_chrome_mask) \
  HEADLESSF(moz_headless_single_get_type) \
  HEADLESSF(moz_headless_single_get)

#define MOZHEADLESS_FUNCTIONS_INTERNAL \
  HEADLESSF(moz_headless_get_nsIWebBrowser) \
  HEADLESSF(moz_headless_get_title_unichar) \
  HEADLESSF(moz_headless_get_js_status_unichar) \
  HEADLESSF(moz_headless_get_link_message_unichar) \
  HEADLESSF(moz_headless_set_directory_service_provider) \
  HEADLESSF(moz_headless_set_app_components)

#define HEADLESSF(fname) fname##Type fname;

MOZHEADLESS_FUNCTIONS
MOZHEADLESS_FUNCTIONS_INTERNAL

#undef HEADLESSF

#define HEADLESSF(fname) { #fname, (NSFuncPtr*) &fname },

static const nsDynamicFunctionLoad HeadlessSymbols[] = {
MOZHEADLESS_FUNCTIONS
  { nsnull, nsnull }
};

static const nsDynamicFunctionLoad HeadlessSymbolsInternal[] = {
MOZHEADLESS_FUNCTIONS_INTERNAL
  { nsnull, nsnull }
};
#undef HEADLESSF

static nsresult
HeadlessEmbedGlueStartup()
{
  return XPCOMGlueLoadXULFunctions(HeadlessSymbols);
}

static nsresult
HeadlessEmbedGlueStartupInternal()
{
  return XPCOMGlueLoadXULFunctions(HeadlessSymbolsInternal);
}

