/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Tom Pixley <joki@netscape.com> (original author)
 *   Johnny Stenback <jst@netscape.com>
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _MOZ_HEADLESS_KEY
#define _MOZ_HEADLESS_KEY

typedef enum {
  MOZ_KEY_CANCEL = 3,
  MOZ_KEY_HELP = 6,
  MOZ_KEY_BACK_SPACE = 8,
  MOZ_KEY_TAB = 9,
  MOZ_KEY_CLEAR = 12,
  MOZ_KEY_RETURN = 13,
  MOZ_KEY_ENTER = 14,
  MOZ_KEY_SHIFT = 16,
  MOZ_KEY_CONTROL = 17,
  MOZ_KEY_ALT = 18,
  MOZ_KEY_PAUSE = 19,
  MOZ_KEY_CAPS_LOCK = 20,
  MOZ_KEY_ESCAPE = 27,
  MOZ_KEY_SPACE = 32,
  MOZ_KEY_PAGE_UP = 33,
  MOZ_KEY_PAGE_DOWN = 34,
  MOZ_KEY_END = 35,
  MOZ_KEY_HOME = 36,
  MOZ_KEY_LEFT = 37,
  MOZ_KEY_UP = 38,
  MOZ_KEY_RIGHT = 39,
  MOZ_KEY_DOWN = 40,
  MOZ_KEY_PRINTSCREEN = 44,
  MOZ_KEY_INSERT = 45,
  MOZ_KEY_DELETE = 46,
  MOZ_KEY_0 = 48,
  MOZ_KEY_1 = 49,
  MOZ_KEY_2 = 50,
  MOZ_KEY_3 = 51,
  MOZ_KEY_4 = 52,
  MOZ_KEY_5 = 53,
  MOZ_KEY_6 = 54,
  MOZ_KEY_7 = 55,
  MOZ_KEY_8 = 56,
  MOZ_KEY_9 = 57,
  MOZ_KEY_SEMICOLON = 59,
  MOZ_KEY_EQUALS = 61,
  MOZ_KEY_A = 65,
  MOZ_KEY_B = 66,
  MOZ_KEY_C = 67,
  MOZ_KEY_D = 68,
  MOZ_KEY_E = 69,
  MOZ_KEY_F = 70,
  MOZ_KEY_G = 71,
  MOZ_KEY_H = 72,
  MOZ_KEY_I = 73,
  MOZ_KEY_J = 74,
  MOZ_KEY_K = 75,
  MOZ_KEY_L = 76,
  MOZ_KEY_M = 77,
  MOZ_KEY_N = 78,
  MOZ_KEY_O = 79,
  MOZ_KEY_P = 80,
  MOZ_KEY_Q = 81,
  MOZ_KEY_R = 82,
  MOZ_KEY_S = 83,
  MOZ_KEY_T = 84,
  MOZ_KEY_U = 85,
  MOZ_KEY_V = 86,
  MOZ_KEY_W = 87,
  MOZ_KEY_X = 88,
  MOZ_KEY_Y = 89,
  MOZ_KEY_Z = 90,
  MOZ_KEY_CONTEXT_MENU = 93,
  MOZ_KEY_NUMPAD0 = 96,
  MOZ_KEY_NUMPAD1 = 97,
  MOZ_KEY_NUMPAD2 = 98,
  MOZ_KEY_NUMPAD3 = 99,
  MOZ_KEY_NUMPAD4 = 100,
  MOZ_KEY_NUMPAD5 = 101,
  MOZ_KEY_NUMPAD6 = 102,
  MOZ_KEY_NUMPAD7 = 103,
  MOZ_KEY_NUMPAD8 = 104,
  MOZ_KEY_NUMPAD9 = 105,
  MOZ_KEY_MULTIPLY = 106,
  MOZ_KEY_ADD = 107,
  MOZ_KEY_SEPARATOR = 108,
  MOZ_KEY_SUBTRACT = 109,
  MOZ_KEY_DECIMAL = 110,
  MOZ_KEY_DIVIDE = 111,
  MOZ_KEY_F1 = 112,
  MOZ_KEY_F2 = 113,
  MOZ_KEY_F3 = 114,
  MOZ_KEY_F4 = 115,
  MOZ_KEY_F5 = 116,
  MOZ_KEY_F6 = 117,
  MOZ_KEY_F7 = 118,
  MOZ_KEY_F8 = 119,
  MOZ_KEY_F9 = 120,
  MOZ_KEY_F10 = 121,
  MOZ_KEY_F11 = 122,
  MOZ_KEY_F12 = 123,
  MOZ_KEY_F13 = 124,
  MOZ_KEY_F14 = 125,
  MOZ_KEY_F15 = 126,
  MOZ_KEY_F16 = 127,
  MOZ_KEY_F17 = 128,
  MOZ_KEY_F18 = 129,
  MOZ_KEY_F19 = 130,
  MOZ_KEY_F20 = 131,
  MOZ_KEY_F21 = 132,
  MOZ_KEY_F22 = 133,
  MOZ_KEY_F23 = 134,
  MOZ_KEY_F24 = 135,
  MOZ_KEY_NUM_LOCK = 144,
  MOZ_KEY_SCROLL_LOCK = 145,
  MOZ_KEY_COMMA = 188,
  MOZ_KEY_PERIOD = 190,
  MOZ_KEY_SLASH = 191,
  MOZ_KEY_BACK_QUOTE = 192,
  MOZ_KEY_OPEN_BRACKET = 219,
  MOZ_KEY_BACK_SLASH = 220,
  MOZ_KEY_CLOSE_BRACKET = 221,
  MOZ_KEY_QUOTE = 222,
  MOZ_KEY_META = 224
} MozHeadlessKey;

typedef enum {
  MOZ_KEY_SHIFT_MASK   = 1 << 0,
  MOZ_KEY_CONTROL_MASK = 1 << 1,
  MOZ_KEY_ALT_MASK     = 1 << 2,
  MOZ_KEY_META_MASK    = 1 << 3,
  MOZ_KEY_LOCK_MASK    = 1 << 4
} MozHeadlessModifier;

#endif /* _MOZ_HEADLESS_KEY */

